/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.world.data.GlobeData;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.configs.ConfigHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class GlobeTextureManager {
    private static final TextureManager TEXTURE_MANAGER = Minecraft.m_91087_().f_90987_;
    private static final Map<String, TextureInstance> TEXTURE_CACHE = Maps.newHashMap();

    public static void refreshTextures() {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world != null) {
            GlobeTextureManager.getTextureInstance((Level)world, false).updateTexture((Level)world);
            GlobeTextureManager.getTextureInstance((Level)world, true).updateTexture((Level)world);
        }
    }

    public static RenderType getRenderType(Level world, boolean sepia) {
        return GlobeTextureManager.getTextureInstance((Level)world, (boolean)sepia).renderType;
    }

    private static TextureInstance getTextureInstance(Level world, boolean sepia) {
        return TEXTURE_CACHE.computeIfAbsent(GlobeTextureManager.getTextureId(world, sepia), i -> new TextureInstance(world, sepia));
    }

    private static String getTextureId(Level level, boolean sepia) {
        Object id = level.m_46472_().m_135782_().m_135815_();
        if (sepia) {
            id = (String)id + "_sepia";
        }
        return id;
    }

    private static class TextureInstance
    implements AutoCloseable {
        private final ResourceLocation textureLocation;
        private final DynamicTexture texture;
        private final RenderType renderType;
        private final String dimensionId;
        private final boolean sepia;

        private TextureInstance(Level world, boolean sepia) {
            this.sepia = sepia;
            this.dimensionId = world.m_46472_().m_135782_().toString();
            this.texture = new DynamicTexture(32, 16, false);
            this.updateTexture(world);
            this.textureLocation = TEXTURE_MANAGER.m_118490_("globe/" + this.dimensionId.replace(":", "_"), this.texture);
            this.renderType = RenderType.m_110446_((ResourceLocation)this.textureLocation);
        }

        private void updateTexture(Level world) {
            GlobeData data = GlobeData.get(world);
            if (data != null) {
                byte[][] pixels = data.globePixels;
                for (int i = 0; i < 16; ++i) {
                    for (int j = 0; j < 32; ++j) {
                        this.texture.m_117991_().m_84988_(j, i, -13061505);
                    }
                }
                for (int y = 0; y < pixels.length; ++y) {
                    for (int x = 0; x < pixels[y].length; ++x) {
                        this.texture.m_117991_().m_84988_(y, x, GlobeColors.getRGBA(pixels[y][x], this.dimensionId, this.sepia));
                    }
                }
                this.texture.m_117985_();
            }
        }

        @Override
        public void close() {
            this.texture.close();
            TEXTURE_MANAGER.m_118513_(this.textureLocation);
        }
    }

    public static class GlobeColors {
        public static final HashMap<String, List<Integer>> DIMENSION_COLOR_MAP = new HashMap();
        public static final List<Integer> DEFAULT_COLORS = new ArrayList<Integer>();
        public static final List<Integer> SEPIA_COLORS = new ArrayList<Integer>();

        public static List<List<String>> getDefaultConfig() {
            ArrayList<List<String>> l = new ArrayList<List<String>>();
            ArrayList<String> col = new ArrayList<String>();
            col.add("minecraft:overworld");
            for (int i = 1; i < 13; ++i) {
                col.add(Integer.toHexString(DEFAULT_COLORS.get((byte)i)));
            }
            l.add(col);
            l.add(Arrays.asList("minecraft:the_nether", "941818", "7b0000", "6a0400", "16615b", "941818", "ca4e06", "e66410", "f48522", "5a0000", "32333d", "118066", "100c1c"));
            l.add(Arrays.asList("minecraft:the_end", "061914", "000000", "2a0d2a", "000000", "d5da94", "cdc68b", "061914", "2a0d2a", "cdc68b", "000000", "eef6b4", "b286b2"));
            return l;
        }

        public static void refreshColorsFromConfig() {
            DIMENSION_COLOR_MAP.clear();
            try {
                List<? extends List<String>> customColors = ConfigHandler.safeGetListString(ClientConfigs.CLIENT_SPEC, ClientConfigs.block.GLOBE_COLORS);
                for (List<String> list : customColors) {
                    if (list.size() < 13) continue;
                    String id = list.get(0);
                    ArrayList<Integer> col = new ArrayList<Integer>();
                    col.add(0);
                    for (int i = 1; i < 13; ++i) {
                        int hex;
                        try {
                            hex = Integer.parseInt(list.get(i).replace("0x", ""), 16);
                        }
                        catch (Exception e) {
                            Supplementaries.LOGGER.warn("failed to parse config 'globe_colors' (at dimension" + id + "). Try deleting them");
                            continue;
                        }
                        col.add(hex);
                    }
                    DIMENSION_COLOR_MAP.put(id, col);
                }
            }
            catch (Exception e) {
                Supplementaries.LOGGER.warn("failed to parse config globe_color configs. Try deleting them");
                DIMENSION_COLOR_MAP.put("minecraft:overworld", new ArrayList<Integer>(DEFAULT_COLORS));
            }
        }

        private static int getRGB(byte b, String dimension, boolean sepia) {
            if (sepia) {
                return SEPIA_COLORS.get(b);
            }
            return DIMENSION_COLOR_MAP.getOrDefault(dimension, DEFAULT_COLORS).get(b);
        }

        public static int getRGBA(byte b, String dimension, boolean sepia) {
            int rgb = GlobeColors.getRGB(b, dimension, sepia);
            return 0xFF000000 | (rgb & 0xFF) << 16 | (rgb >> 8 & 0xFF) << 8 | rgb >> 16 & 0xFF;
        }

        static {
            DEFAULT_COLORS.add(0, 0);
            DEFAULT_COLORS.add(1, 2319757);
            DEFAULT_COLORS.add(2, 2445949);
            DEFAULT_COLORS.add(3, 1915245);
            DEFAULT_COLORS.add(4, 2984540);
            DEFAULT_COLORS.add(5, 3448890);
            DEFAULT_COLORS.add(6, 7250251);
            DEFAULT_COLORS.add(7, 9021501);
            DEFAULT_COLORS.add(8, 11909733);
            DEFAULT_COLORS.add(9, 13424597);
            DEFAULT_COLORS.add(10, 8631494);
            DEFAULT_COLORS.add(11, 3113890);
            DEFAULT_COLORS.add(12, 8547953);
            DEFAULT_COLORS.add(13, 9340533);
            DEFAULT_COLORS.add(14, 2984540);
            DEFAULT_COLORS.add(15, 12749127);
            DEFAULT_COLORS.add(16, 12230501);
            DEFAULT_COLORS.add(17, 12230501);
            DEFAULT_COLORS.add(18, 7770473);
            SEPIA_COLORS.add(0, 0);
            SEPIA_COLORS.add(1, 12301734);
            SEPIA_COLORS.add(2, 10920080);
            SEPIA_COLORS.add(3, 9472632);
            SEPIA_COLORS.add(4, 8747877);
            SEPIA_COLORS.add(5, 7759959);
            SEPIA_COLORS.add(6, 6773322);
            SEPIA_COLORS.add(7, 7759959);
            SEPIA_COLORS.add(8, 8747877);
            SEPIA_COLORS.add(9, 7759959);
            SEPIA_COLORS.add(10, 8747877);
            SEPIA_COLORS.add(11, 9472632);
            SEPIA_COLORS.add(12, 8747877);
            SEPIA_COLORS.add(13, 8747877);
        }
    }
}

